/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

class OutlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private Color color;

    OutlineHighlightPainter(Color color) {
        super(color);
        this.setColor(color);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Shape paintLayer(Graphics g2, int p0, int p1, Shape viewBounds, JTextComponent c2, View view) {
        g2.setColor(this.getColor());
        if (++p0 == p1) {
            try {
                Shape s2 = view.modelToView(p0, viewBounds, Position.Bias.Forward);
                Rectangle r2 = s2.getBounds();
                g2.drawLine(r2.x, r2.y, r2.x, r2.y + r2.height);
                return r2;
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return null;
            }
        }
        if (p0 == view.getStartOffset() && p1 == view.getEndOffset()) {
            Rectangle alloc = viewBounds instanceof Rectangle ? (Rectangle)viewBounds : viewBounds.getBounds();
            g2.drawRect(alloc.x, alloc.y, alloc.width - 1, alloc.height - 1);
            return alloc;
        }
        try {
            Shape shape = view.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, viewBounds);
            Rectangle r3 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            g2.drawRect(r3.x, r3.y, r3.width - 1, r3.height - 1);
            return r3;
        }
        catch (BadLocationException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color cannot be null");
        }
        this.color = color;
    }
}

